//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------


#include "RenderBridge.h"
#include "RenderCore.hpp"
#include <MetalKit/MetalKit.h>
#include <memory>


// Typically these would be constants, however they are
// defined mutable to configure them via command line.
float kDefaultTessellationInnerValue = 5.0f;
float kDefaultAnimationFactor        = 1.0f;
RenderMode kDefaultRenderMode        = RM_GS_TS;

@implementation RenderBridge
{
    std::unique_ptr< RenderCore > _pRenderCore;
}

-(nonnull instancetype)initWithMetalKitView:(nonnull MTKView *)view;
{
    self = [super init];
    if(self)
    {
        NSString* shaderPath = [[NSBundle mainBundle] resourcePath];
        _pRenderCore = std::make_unique< RenderCore >( (__bridge MTL::Device *)view.device, shaderPath.UTF8String );
    }

    return self;
}

- (void)drawInMTKView:(nonnull MTKView *)view
{
    _pRenderCore->draw((__bridge MTL::RenderPassDescriptor *)view.currentRenderPassDescriptor,
                       (__bridge CA::MetalDrawable *)view.currentDrawable);
}

- (void)mtkView:(nonnull MTKView *)view drawableSizeWillChange:(CGSize)size
{
    _pRenderCore->resizeDrawable( size.width, size.height );
}

@end
