RaytracingAccelerationStructure accelStructure : register(t0, space0);
RWTexture2D<float4> outTexture : register(u0, space1);

struct RayPayload
{
    float4 color;
};

[shader("raygeneration")]
void MainRayGen()
{
    uint uavW = 0, uavH = 0;
    
    outTexture.GetDimensions(uavW, uavH);
    
    uint2 rayIndex = DispatchRaysIndex().xy;
    
    if (rayIndex.x < uavW && rayIndex.y < uavH)
    {
        uint2 rayDimensions = (float2)DispatchRaysDimensions();
        
        RayDesc r;
        r.Origin = float3(0, 0, 0);
        r.Direction = float3( float2(rayIndex)/float2(rayDimensions) * 2.0 - 1.0, -1.0 );
        r.Direction.y *= -1.0;
        r.TMin = 0.04;
        r.TMax = 100.0;
        
        RayPayload payload;
        payload.color = float4(1.0, 0, 0.0, 0);
        
        uint instanceMask = 255;
        uint rayContribToHG = 0;
        uint geomMultiplier = 1;
        uint missShaderIndex = 0;
        TraceRay(accelStructure,
                 RAY_FLAG_NONE,
                 instanceMask,
                 rayContribToHG,
                 geomMultiplier,
                 missShaderIndex,
                 r,
                 payload);
        
        outTexture[rayIndex.xy] = payload.color;
    }
}

[shader("miss")]
void MainMiss(inout RayPayload payload)
{
    payload.color = float4(1, 0, 1, 0);
}

struct LocalData
{
    int numHoles;
};

ConstantBuffer<LocalData> localData : register(b0, space16);

[shader("closesthit")]
void TriangleClosestHit(inout RayPayload payload, BuiltInTriangleIntersectionAttributes attr)
{
    float value = 1.0;
    
    int numHoles = localData.numHoles;

    float3 p = WorldRayOrigin() + WorldRayDirection() * RayTCurrent();
    
    float3 pt = mul(WorldToObject3x4(), float4(p, 1.0)).xyz;

    for (int i = 0; i < numHoles; ++i)
    {
        float phase = i / (float)numHoles;
        float angle = phase * 6.28;
        
        float x = sin(angle) * 0.3;
        float y = cos(angle) * 0.3;
        
        if (length(pt.xy - float2(x, y)) < 0.15)
        {
            value = 0.25;
        }
    }
    
    float3 barycentrics = float3( 1 - attr.barycentrics.x - attr.barycentrics.y, attr.barycentrics.xy );
    
    payload.color = float4(barycentrics * value, 1.0);
}

[shader("anyhit")]
void TriangleAnyHit(inout RayPayload payload, BuiltInTriangleIntersectionAttributes attr)
{
    int numHoles = localData.numHoles;

    float3 p = WorldRayOrigin() + WorldRayDirection() * RayTCurrent();
    
    float3 pt = mul(WorldToObject3x4(), float4(p, 1.0)).xyz;
    
    for (int i = 0; i < numHoles; ++i)
    {
        float phase = i / (float)numHoles;
        float angle = phase * 6.28;
        
        float x = sin(angle) * 0.3;
        float y = cos(angle) * 0.3;
        
        if (length(pt.xy - float2(x, y)) < 0.1)
        {
            IgnoreHit();
        }
    }
}
