//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2023 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------------------------------------------------------------------
// This project includes a pre-compiled version of this file.
// In order to modify it, you need to build the DirectX
// Shader Compiler. Please see the README for instructions.
//-------------------------------------------------------------------------------------------------------------------------------------------------------------


struct CameraData
{
    float4x4 perspectiveTransform;
};

ConstantBuffer<CameraData> cameraData : register(b0, space0);

struct VertexIn
{
    float4 position : POSITION;
};

struct v2f
{
    float4 position : SV_Position;
    float3 color : COLOR;
};

struct v2g
{
    float4 position : SV_Position;
};

struct g2f
{
    float4 position : SV_Position;
    float3 normal : NORMAL;
    float3 color : COLOR;
};

v2g MainVS( VertexIn vin )
{
    v2g o = (v2g)0;
    o.position = mul( cameraData.perspectiveTransform, vin.position );
    return o;
}

struct FrameData
{
    float frameAnim;
};

ConstantBuffer<FrameData> frameData : register(b1, space0);

[maxvertexcount(6)]
void MainGS( triangle v2g triIn[3], inout TriangleStream<g2f> triangleStream )
{
    g2f v0, v1, v2;

    float4 p0 = triIn[0].position;
    float4 p1 = triIn[1].position;
    float4 p2 = triIn[2].position;

    float3 s0 = (p2 - p0).xyz;
    float3 s1 = (p1 - p0).xyz;
    float3 n = normalize( cross( s0, s1 ).xyz );

    v0.position = p0;
    v0.normal = n;
    v0.color = float3(0.2, 0.2, 0.2);
    
    v1.position = p1;
    v1.normal = n;
    v1.color = float3(0.2, 0.2, 0.2);
    
    v2.position = p2;
    v2.normal = n;
    v2.color = float3(0.2, 0.2, 0.2);
    
    triangleStream.Append(v0);
    triangleStream.Append(v1);
    triangleStream.Append(v2);
    
    
    // new tri
    float4 center = (p0 + p1 + p2)/3;
    g2f v3, v4, v5;
    v3.position = float4(center.x - 0.05, center.yzw);
    v3.color = float3(0.0, 0.15, 0.0);
    v3.normal = float3(0.0, 0.0, 1.0);
    
    v4.position = float4(center.x + 0.05, center.yzw);
    v4.color = float3(0.0, 0.15, 0.0);
    v4.normal = float3(0.0, 0.0, 1.0);
    
    float f = center.x * center.z;
    v5.position = float4(center.x + sin(center.z*100+sin(frameData.frameAnim)*0.1)*frac(tan(f))*0.1, center.y + 0.5, center.z, center.w);
    v5.color = float3(0.0, 0.85, 0.0);
    v5.normal = float3(0.0, 0.0, 1.0);
    
    triangleStream.Append(v3);
    triangleStream.Append(v4);
    triangleStream.Append(v5);
}

float4 MainFS( g2f vin ) : SV_Target
{
    return float4(vin.color, 1.0);
}
