//
//  MasterViewController.swift
//  SSO TVE Tester
//
//  Copyright © 2016 Apple, Inc. All rights reserved.
//

import UIKit

class MasterViewController: UITableViewController, AMPresenter {

    var authManager : AuthManager?
    var detailViewController: DetailViewController? = nil
    var objects = [AnyObject]()


    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        authManager = AuthManager(self)

        if let split = self.splitViewController {
            let controllers = split.viewControllers
            self.detailViewController = (controllers[controllers.count-1] as! UINavigationController).topViewController as? DetailViewController
            if #available(iOS 13.0, *) {
                switch split.traitCollection.userInterfaceStyle {
                    case .light:
                        split.overrideUserInterfaceStyle = .light
                    case .dark:
                        split.overrideUserInterfaceStyle = .dark
                    case .unspecified:
                        break
                default:
                    break
                }
                
            }
        }
    }

    override func viewWillAppear(_ animated: Bool) {
        self.clearsSelectionOnViewWillAppear = self.splitViewController!.isCollapsed
        super.viewWillAppear(animated)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    // MARK: - Segues
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == "showDetail" {
            if let indexPath = self.tableView.indexPathForSelectedRow {
                
                let controller = (segue.destination as! UINavigationController).topViewController as! DetailViewController
                controller.navigationItem.leftBarButtonItem = self.splitViewController?.displayModeButtonItem
                controller.navigationItem.leftItemsSupplementBackButton = true
                
                if let log = self.detailViewController?.log {
                    controller.log = log
                }
                
                self.detailViewController = controller
                
                let object = MenuItems[indexPath.row]
                object.action(authManager!)
                
            }
        }
    }


    // MARK: - Table View

    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }

    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return MenuItems.count
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "Cell", for: indexPath)

        let object = MenuItems[indexPath.row]
        cell.textLabel!.text = object.label
        
        return cell
    }

    // MARK: AM Presenter
    
    func presentMessage(_ title: String, message: String) {
        let newMessage = "\(title): \n\(message)" + "\r\n"
        print(newMessage)
        
        DispatchQueue.main.async {
            if let controller  = self.detailViewController {
                controller.appendLog(newMessage)
            }
        }
    }
    
    func presentViewController(_ viewController: UIViewController) {
        DispatchQueue.main.async {
            self.navigationController?.present(viewController, animated: true, completion: nil)
        }
    }
    
    func dismissViewController(_ viewController: UIViewController) {
        DispatchQueue.main.async {
            self.navigationController?.dismiss(animated: true, completion: nil)
        }
    }


}

